<?php
/*
Plugin Name: Chatbot Schmiede Integration
Plugin URI: https://chatbot-schmiede.de
Description: Erlaubt das einfache Einfügen des Chatbot-Integrationscodes der Chatbot Schmiede
Version: 2.6.5
Author: CHATBOT SCHMIEDE
Author URI: https://chatbot-schmiede.de
*/

// Sicherheit: Direktzugriff verhindern
if (!defined('ABSPATH')) {
    exit;
}

// Menüeintrag hinzufügen
add_action('admin_menu', function () {
    add_menu_page(
        'Chatbot Schmiede', 
        'Chatbot', 
        'manage_options', 
        'chatbot-schmiede', 
        'chatbot_schmiede_settings_page', 
        'dashicons-format-chat'
    );
});

// Plugin-Einstellungslink hinzufügen
add_filter('plugin_action_links_' . plugin_basename(__FILE__), function ($links) {
    $settings_link = '<a href="admin.php?page=chatbot-schmiede">Einstellungen</a>';
    array_unshift($links, $settings_link);
    return $links;
});

// Plugin-Meta-Link für Support
add_filter('plugin_row_meta', function ($links, $file) {
    if (plugin_basename(__FILE__) === $file) {
        $links[] = '<a href="https://chatbot-schmiede.de/support" target="_blank">Support</a>';
    }
    return $links;
}, 10, 2);

// Einstellungsseite anzeigen
function chatbot_schmiede_settings_page() {
    ?>
    <div class="wrap">
        <br>
        <br>
        <div style="text-align:left; margin-bottom:20px;">
            <img src="<?php echo plugin_dir_url(__FILE__) . 'logo.png'; ?>" alt="Chatbot Schmiede Logo" width="250" height="32">
        </div>
        <?php
        $bot_id = esc_attr(get_option('chatbot_schmiede_code'));
        if ($bot_id) {
            echo '<div style="margin-bottom: 20px; color: green; font-weight: bold;"><span style="font-size: 20px;">✔</span> Der Bot ist aktiviert!</div>';
        } else {
            echo '<div style="margin-bottom: 20px; color: red; font-weight: bold;"><span style="font-size: 20px;">✘</span> Es ist kein Bot aktiviert!</div>';
        }
        ?>
        <?php if (isset($_GET['settings-updated']) && $_GET['settings-updated']) : ?>
            <div id="message" class="updated notice is-dismissible">
                <p>Speichern erfolgreich.</p>
            </div>
        <?php endif; ?>
        <form method="post" action="options.php" style="display: flex; align-items: center; gap: 10px;">
            <?php
            settings_fields('chatbot_schmiede_settings');
            ?>
            <label for="chatbot_schmiede_code" style="font-weight: 600; margin-right: 10px;">Bot-ID:</label>
            <input type="text" id="chatbot_schmiede_code" name="chatbot_schmiede_code" value="<?php echo $bot_id; ?>" style="width: 120px;" placeholder="z. B. 14693" />
            <?php submit_button('Speichern', 'primary', 'submit', false); ?>
            <a href="https://chatbot-schmiede.de/support" class="button button-secondary" style="margin-left: 10px;" target="_blank" title="Hier kannst du neue Informationen übermitteln, z. B. Eventdaten, Produktdaten oder Reaktionen.">Support</a>
        </form>
    </div>
    <?php
}

// Einstellung registrieren
add_action('admin_init', function () {
    register_setting('chatbot_schmiede_settings', 'chatbot_schmiede_code', [
        'sanitize_callback' => 'sanitize_text_field'
    ]);
});

// Integration im Frontend einfügen
add_action('wp_footer', function () {
    $bot_id = get_option('chatbot_schmiede_code');
    if ($bot_id) {
        echo '<script src="https://app.aminos.ai/js/chat_plugin.js" data-bot-id="' . esc_attr($bot_id) . '"></script>';
    }
});
